function [lampT, maxLampT, cooldownHalf] = simLamp(cap,hec,airT,input)
%SIMLAMP Summary of this function goes here
%   Detailed explanation goes here

    simLength = 3600*6;
    halfSim = simLength/2;
    
    lampT = nan(1,simLength);
    
    lampT(1) = airT;

    for t=2:halfSim
        lampT(t) = lampT(t-1) + 1/cap*(hec*(airT-lampT(t-1))+input);
    end
    
    maxLampT = lampT(halfSim);
    halfMax = (maxLampT+airT)/2;
    
    for t=(halfSim+1):simLength
        lampT(t) = lampT(t-1) + 1/cap*(hec*(airT-lampT(t-1)));
        if lampT(t) < halfMax && lampT(t-1) > halfMax
            cooldownHalf = interp1(lampT(t-1:t),[t-1 t], halfMax)-halfSim;
        end
    end
    
    plot(lampT);
end

